/* - EncoderInputListener -
 * 
 * on the current Phidget Encoders, this means the pushbutton in the knob.
 * Event arguements contain the input index (on current Phidget Encoders will 
 * only be 1) and the value, a bool to represent clicked or unclicked state.
 * 
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.InputChangeListener;
import com.phidgets.event.InputChangeEvent;

import javax.swing.JCheckBox;

public class EncoderInputListener implements InputChangeListener{
    
    private JCheckBox inputChk;
    
    /**
     * Creates a new instance of EncoderInputListener
     */
    public EncoderInputListener(JCheckBox inputChk)
    {
        this.inputChk = inputChk;
    }

    public void inputChanged(InputChangeEvent inputChangeEvent)
    {
        inputChk.setSelected(inputChangeEvent.getState());
    }
    
}
